#include <bits/stdc++.h>

using namespace std;

const int MAXN = 150005;
struct Trkac {
	int x;
	int v;
	double pos;
	int index;

	void SetT(double T) {
		pos = (double)x + T * (double)v;
	}

	bool operator<(const Trkac& other) const {
		return this->pos < other.pos;
	}
};

Trkac vec[MAXN];
int n;
int k;

int fenvik[MAXN];

void update(int i, int x) {
	while(i <= n) {
		fenvik[i] += x;
		i += (i & (-i));
	}
}

long long querry(int i) {
	long long sum = 0;
	while(i > 0) {
		sum += fenvik[i];
		i -= (i & (-i));
	}
	return sum;
}

long long BrojPreticanja(double T) {
	// O(N)
	for (int i = 0; i < n; i++) {
		vec[i].SetT(T);
	}
	// O(NlogN)
	sort(vec, vec + n);

	// O(N)
	for (int i = 0; i < MAXN; i++) {
		fenvik[i] = 0;
	}

	// O(NlogN)
	long long ans = 0;
	update(vec[0].index, 1);
	for (int i = 1; i < n; i++) {
		ans += (long long)(i - querry(vec[i].index));
		update(vec[i].index, 1);
	}

	/*
	for (int i = 0; i < n; i++) {
		cout << vec[i].index << " ";
	}
	cout << endl;
	cout << ans << endl;
	*/

	return ans;
}


int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(0); cout.tie(0);

	cin >> n >> k;
	for (int i = 0; i < n; ++i)
	{
		cin >> vec[i].x >> vec[i].v;
		vec[i].index = i+1;
	}

	double epsilon = 1e-7;
	double l = 0;
	double r = 1e9;
	//cout << l << " " << r << " " << epsilon << endl;
	while (r - l >= epsilon) {
		double mid = l + (r - l) / 2.0;
		//cout << l << " " << r << endl;
		long long br_preticanja = BrojPreticanja(mid);
		//cout << br_preticanja << endl;
		if (br_preticanja >= k) {
			r = mid;
		}
		else if (br_preticanja < k) {
			l = mid;
		}
	}
	cout << r << endl;


	return 0;
}